# UM Oscilloscope

Программный осциллограф для мониторинга состояния и параметров системы uMotor.

## Запуск:

1. Запуск приложения:
	Windows:
	```
	um_oscilloscope.exe
	```

	 или

	Linux:
	```
	um_oscilloscope
	```
2. Ввести валидные IP-адрес и номер порта данных в текстовых полях "IP-адрес сервера" и "Номер порта для данных".
3. Подключиться к серверу с помощью кнопки "Подключение".
4. Выбрать необходимое количество каналов для работы (от 1 до 8) с помощью выпадающего списка "Количество каналов".
5. Выбрать для нужных каналов величину, которая будет отображена, в колонке "Величина".
6. Поставить галочку в чекбоксе "Отображение" соответствующих каналов.

## Использование

На данный момент софт позволяет:
* вкладка __Осциллограф__:
** настроить отображаемые каналы:
*** их количество с помощью выпадающего списка __Количество каналов__
*** отображение того или иного канала на графике в данный момент с помощью галочки в графе __Отображение__. Обратите внимание, что часть данных, помеченных в названии __REF__, являются вычитанными рефернсными значениями заданной траектории.
*** выбрать источник сигнала с помощью соответствующего каналу выпадающего списка в графе __Величина__
*** выбрать текущий множитель для данного канала (его данные будут умножены на выбранную величину) с помощью выпадающего списка в графе __Множитель__
** включить или выключить автообновление графиков с помощью галочки __Автообновления__ для того, чтобы видеть новые данные по мере их накопления или чтобы зафиксировать текущую развертку и изучать её более детально

* вкладка __Траектория 2D__:
** с помощью выпадающих списков _X_ и _Y_ можно выбрать номера осей, которые будут интерпретироваться как, соответственно, X и Y оси
** с помощью кнопки _Старт_ можно включить запись 2D траектории для выбранных  осей
** с помощью кнопки _Стоп_ можно остановить запись 2D траектории, при этом при следующем нажатии кнопки _Старт_ данные начнут писаться заново
** с помощью кнопки _Пауза_ можно приостановить запись 2D траектории, при этом при следующем нажатии кнопки _Старт_ данные будут запись к уже записанным
** галочки _Траектория_ и _Данные от времени_ позволяеют переключаться между способом отображения данных 2D траектории: между самой траекторией и данными (позиции и скорости для двух выбранных осей) во времени (шкала X в секундах)
** выпадающий списко _Отображать каждую # точку_ позволяет выбрать частоту точек отображаемых на графике относительно записанных данных. При установке этого параметра в значение, отличное от 1, будет отображаться каждая # точка и скорость обновления графиков будет выше. После остановки записи этот параметр можно менять и более детально изучать уже все записанные данные.
** в выбранном режиме отображения _Данные от времени_ можно, аналогично с основной вкладкой _Осциллограф_ выбирать, какие данные будут отображены на графике и с каким множителем
** в полях "Максимальная ошибка по позиции X / Y" будут отображаться макисмальные ошибки по позиции для, соответственно, X и Y осей в текущей записи 2D-траектории во внутренних единицах системы.
** при остановке записи в этом режиме на графиках можно воспользоваться программной линейкой для измерения реального расстояния между точками на графике:
*** остановите запись данных с помощью кнопки _Стоп_ или _Пауза_
*** убедитесь, что в стандартной matplotlib-панели не выбрана никакая опция для увеличения / перемещения графика (никакая опция не подсвечена)
*** с помощью левой кнопки мыши соедините две точки на графике, между которыми треубется измерить расстояние
*** на графике появится надпись, где __L__ - общее расстояние, __dx__ - расстояние вдоль оси X, __dy__ - расстояние вдоль оси Y, __ang__ - угол наклона получившегося отрезка
*** при нажатии правой кнопкой мыши на один из концов получившегося отрезка можно, не меняя положения другого конца, изменить его положение
*** при нажатии правой кнопкой мыши на середину отрезка, отмечанного точкой, можно перетаскивать весь отрезок целиком
*** убрать отрезок линейки с графика можно с помощью двойного нажатия левой кнопки мыши в любую область графика

* Общие возможности:
** стандартная matplotlib-панель для увеличения/настройки/сохранения графика (будет корректно работать только при убранной галочке __Автообновление__ во вкладке __Осциллограф__ и остановленой записи 2D траектории в __Траектория 2D__)
** также можно выгрузить данные, соответствующие отображенным на экране, в формате dat файла для каждого поля (не только для тех, которые сейчас отображены на графике во вкладке __Осциллограф__ или в режиме отображения данных во времени во вкладке __Траектория 2D__, но вообще для всех полей, которые есть в данных) с помощью кнопки __Выгрузить данные__ над графиком. При нажатии на кнопку рядом с ней появится название папки, куда данные были сохранены - название этой папки формируется по актуальной дате и времени: __data_DD_MM_YYYY_H_M_S__. Общее название папки для данных - __data_saved__. При этом в папке __data_DD_MM_YYYY_H_M_S__ появятся файлы для каждого поля по его названию: например для __Позиция / Ось 1@ -> @Позиция_Ось_1.dat__.
** _отладочная функция_: сигнал о приходе новых данных от сервера (для индикации его жизнеспособности) - кнопка @Новые данные@. Мигает при подключении к серверу, если новые данные приходят корректно.
