# um_gcode_loader

Интерполятор G-кодов в траектории и загрузчик интерполированных траекторий в КСУ.

## Запуск

Считается, что в сети есть КСУ с запущенной UMOS и на нем уже запущен сервер загрузчика `um_stream_loader_server` для подключения загрузчика и основной сервер управления системой `um_control_server`.

### На клиенте (ПК):

1. Запустить приложение:
  - Windows: Двойным нажатием на `um_gcode_loader.exe`.
  - Linux: для доступа к файловой системе требуется открытие приложение с root-правами:
    ```
    sudo ./um_gcode_loader
    ```
2. С помощью `revealer` или сетевого поиска Windows определить IP-адрес КСУ (umotor KSU MotherBoard [S/N #], где # - серийный номер вашего контроллера).
3. Указать найденный IP-адрес в поле __IP-адрес сервера__.
4. Если сервер на устройстве был запущен не с дефолтными значениями портов, то указать в окнах соответствующие номера для data и info портов.
5. Подключиться к серверу кнопкой __Подключение__.
6. Во вкладке __Settings__ выбрать все необходимые настройки:
  - режим сглаживания траектории (да / нет)
  - убрать или оставить галочку __Обновить соответствие осей при старте__. При ее наличии соответствие букв и номеров осей будет обновлено при запуске выполнения траектории. При ее отсутствии соответствие нужно задать вручную с помощью выпадающего списка. Оси 9 и 10 - оси гальвосканера, при выборе такой пары осей для X и Y в интерполяторе автоматически будет выбран режим galvo, при котором отсутствуют участки с ускорениями (считаем, что скорость меняется бесконечно быстро).
  - режим бесконечного повторения траектории (для гальво-осей)
  - ускорения и производные ускорения (jerk) для рабочих осей (X, Y, Z, U, V, W)
  - отрицательную задержку включения лазера (применяется к команде M100 P1). Отрицательная задержка не может быть более 1 сек.
4. Если будет загружен файл в g-кодах, то поставить (проверить) галочку __G-Code__.
5. Выбрать файл для загрузки через кнопку __Выбрать файл__.
6. Для запуска движения нажать кнопку __Старт__.
7. Дождаться конца интерполяции и загрузки файла.

__Обратите внимание__, что для получения результатов выполнения траекторий нужно дополнительно включить осциллограф "UM Oscilloscope" (на сетевом диске в папке ..\data\uMotor\uM-software\um_oscillosope) по приложенной к нему инструкции и во вкладке __Траектория 2D__ нажать кнопку "Старт", чтобы начать запись 2D траектории для выбранных осей X и Y, и "Стоп", чтобы завершить.

## Конфигурационный файл config.ini

Конфигурационный файл `config.ini` разделен на три части:

* `[INTERPOLATOR]` - настройки интерполятора:
  - `system_config_file` - путь до настроечного файла системы (КСУ). Изменять этот путь не рекомендуется. Обязательный параметр.
  - `specific_device_file` - путь до настроечного файла подключаемого станка (параметры осей). Изменять этот путь не рекомендуется. Обязательный параметр.
  - `working_config_file` - путь до файла с рабочими параметрами станка (осей), которые будут использованы при интерполяции программ без задаваемых явным образом скоростей. Изменять этот путь не рекомендуется. Обязательный параметр.
  - `velocity_limit_checking` - флаг включения проверки модуля скорости на отрезках. При выставлении этого параметра в `= true` проверка будет включена и для сегментов, на которых какая-то из осей не успевает развивать полную запрашиваемую скорость, модуль скорость будет понижена. Если этот параметр выставлен в `= false`, то проверка будет выключена.
* `[LOADER_SERVER]` - настройки подключения к серверу um_stream_loader_server:
  - `ip_address` - IP-адрес КСУ, который будет указан в окне "IP-адрес сервера" при старте um_gcode_loader. Этот адрес автоматически перезаписывается при успешном подключении к серверу с помощью кнопки "Подключение".
  - `port_info` - номер TCP-порта для служебных команд на сервере um_stream_loader_server.
  - `port_data` - номер TCP-порта для отправки траектории на сервер um_stream_loader_server.
* `[CONSOLE_SERVER]` - настройки внутреннего XML-RPC сервера um_gcode_loader:
  - `port` - номер порта, на котором будет запущен сервер. Он запускается на локальном адресе 127.0.0.1. Отличие этого номера порта от дефолтного номера 40000 может привести к проблемам при подключении стандартных программ (например, gcodebin_server для работы через LaserCNC), поэтому изменение этого номера не рекомендуется.
	
